//
//  ZPLPrinterVC.m
//  PrinterDemo
//
//  Created by Apple Mac mini intel on 2024/5/4.
//

#import "ZPLPrinterVC.h"
#import "XSDKPrinter.h"
#import "UIView+Toast.h"

@interface ZPLPrinterVC ()<XBLEManagerDelegate, XWIFIManagerDelegate>

@property (weak, nonatomic) IBOutlet UISwitch *directionSwitch;
@property (weak, nonatomic) IBOutlet UISlider *speedSlider;
@property (weak, nonatomic) IBOutlet UISlider *densitySlider;
@property (weak, nonatomic) IBOutlet UISegmentedControl *numSegment;
@property (weak, nonatomic) IBOutlet UILabel *speedLabel;
@property (weak, nonatomic) IBOutlet UILabel *densityLabel;
// bluetooth manager
@property (strong, nonatomic) XBLEManager *bleManager;
@property (strong, nonatomic) XWIFIManager *wifiManager;
@end

@implementation ZPLPrinterVC

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"ZPL PRINT";
    _bleManager = [XBLEManager sharedInstance];
    _bleManager.delegate = self;
    _wifiManager = [XWIFIManager sharedInstance];
    _wifiManager.delegate = self;
}

- (IBAction)printTextAction:(id)sender {
    XZPLCommand *command = [[XZPLCommand alloc] init];
    [command start];
    [command setLabelLength:400];
    [command addTextAtX:10 y:0 fontName:kFNT_A rotation:ZPLRotation0 sizeW:9 sizeH:5 content:@"fontA"];
    [command addTextAtX:10 y:20 fontName:kFNT_B rotation:ZPLRotation0 sizeW:11 sizeH:7 content:@"fontB"];
    [command addTextAtX:10 y:40 fontName:kFNT_C rotation:ZPLRotation0 sizeW:18 sizeH:10 content:@"fontC"];
    [command addTextAtX:10 y:60 fontName:kFNT_D rotation:ZPLRotation0 sizeW:18 sizeH:10 content:@"fontD"];
    [command addTextAtX:10 y:90 fontName:kFNT_F rotation:ZPLRotation0 sizeW:26 sizeH:13 content:@"fontF"];
    [command addTextAtX:10 y:130 fontName:nil rotation:ZPLRotation0 sizeW:0 sizeH:0 content:@"fontE"];
    [command addTextAtX:10 y:160 fontName:kFNT_G rotation:ZPLRotation0 sizeW:60 sizeH:40 content:@"fontG"];
    [command addTextAtX:10 y:220 fontName:kFNT_0 rotation:ZPLRotation0 sizeW:15 sizeH:12 content:@"font0"];
    [command addTextAtX:350 y:250 fontName:kFNT_E rotation:ZPLRotation0 sizeW:28 sizeH:15 content:@"E0"];
    [command addTextAtX:250 y:250 fontName:kFNT_E rotation:ZPLRotation90 sizeW:28 sizeH:15 content:@"E90"];
    [command addTextAtX:250 y:350 fontName:kFNT_E rotation:ZPLRotation180 sizeW:28 sizeH:15 content:@"E180"];
    [command addTextAtX:350 y:350 fontName:kFNT_E rotation:ZPLRotation270 sizeW:28 sizeH:15 content:@"E270"];
    
    [command end];
    [self printWithData:[command getCommand]];
}

- (IBAction)printBarcode1Action:(id)sender {
    XZPLCommand *command = [[XZPLCommand alloc] init];
    [command start];
    [command setPrinterWidth:560];
    
    [command addTextAtX:50 y:100 content:@"Code 11"];
    [command addBarcodeAtX:50 y:150 codeType:ZPLBarCode11 content:@"123456"];
    [command addTextAtX:360 y:100 content:@"Code 25"];
    [command addBarcodeAtX:360 y:150 codeType:ZPLBarCode25 content:@"123456"];
    
    [command addTextAtX:50 y:300 content:@"Code 39"];
    [command addBarcodeAtX:50 y:350 codeType:ZPLBarCode39 content:@"CODE39"];
    [command addTextAtX:360 y:300 content:@"EAN 8"];
    [command addBarcodeAtX:360 y:350 codeType:ZPLBarCodeEAN8 content:@"1234567"];
    
    [command addTextAtX:50 y:500 content:@"UPC E"];
    [command addBarcodeAtX:50 y:550 codeType:ZPLBarCodeUPCE content:@"0123456"];
    [command addTextAtX:360 y:500 content:@"Code 93"];
    [command addBarcodeAtX:360 y:550 codeType:ZPLBarCode93 content:@"CODE93"];
    
    [command end];
    [self printWithData:[command getCommand]];
}


- (IBAction)printBarcode2Action:(id)sender {
    XZPLCommand *command = [[XZPLCommand alloc] init];
    [command start];
    [command setPrinterWidth:560];
    
    [command addTextAtX:20 y:100 content:@"Code 128"];
    [command addBarcodeAtX:20 y:150 codeType:ZPLBarCode128 content:@"CODE128" height:90];
    [command addTextAtX:300 y:100 content:@"EAN 13"];
    [command addBarcodeAtX:300 y:150 codeType:ZPLBarCodeEAN13 content:@"123456789012" height:90];
    
    [command addTextAtX:20 y:300 content:@"CODA"];
    [command addBarcodeAtX:20 y:350 codeType:ZPLBarCodeCODA content:@"123456" height:90];
    [command addTextAtX:300 y:300 content:@"MSI"];
    [command addBarcodeAtX:300 y:350 codeType:ZPLBarCodeMSI content:@"123456" height:90];
    
    [command addTextAtX:20 y:500 content:@"PLESSEY"];
    [command addBarcodeAtX:20 y:550 codeType:ZPLBarCodePLESSEY content:@"123456" height:90];
    
    [command addTextAtX:20 y:700 content:@"UPC A"];
    [command addBarcodeAtX:20 y:750 codeType:ZPLBarCodeUPCA content:@"123456789012" height:90];
    
    [command addTextAtX:300 y:700 content:@"UPC EAN"];
    [command addBarcodeAtX:300 y:750 codeType:ZPLBarCodeUPCEAN content:@"12345" height:90];
    
    [command end];
    [self printWithData:[command getCommand]];
}

- (IBAction)printQrcodeAction:(id)sender {
    XZPLCommand *command = [[XZPLCommand alloc] init];
    [command start];
    [command setPrinterWidth:560];
    [command addQRCodeAtX:0 y:100 factor:6 text:@"0123456789ABCD 2D code"];
    [command end];
    [self printWithData:[command getCommand]];
}

- (IBAction)printGeometryAction:(id)sender {
    XZPLCommand *command = [[XZPLCommand alloc] init];
    [command start];
    // Add a rectangle
    [command addBoxAtX:100 y:100 width:200 height:150 thickness:10];
    // Add a right diagonal line
    [command addGraphicDiagonalLineAtX:50 y:50 orientation:DiagonalDirectionRight width:400 height:200 thickness:5];
    // Add a left diagonal line
    [command addGraphicDiagonalLineAtX:50 y:50 orientation:DiagonalDirectionLeft width:400 height:200 thickness:5];
    // Add an ellipse
    [command addGraphicEllipseAtX:150 y:150 width:200 height:100 thickness:2];
    // Add a circle
    [command addGraphicCircleAtX:200 y:200 diameter:100 thickness:1];
    [command end];
    [self printWithData:[command getCommand]];
}

- (IBAction)printImageAction:(id)sender {
    XZPLCommand *command = [[XZPLCommand alloc] init];
    [command start];
    [command printImageAtX:0 y:50 image:[UIImage imageNamed:@"image"]];
    [command end];
    [self printWithData:[command getCommand]];
}

- (IBAction)downloadGraphicAction:(id)sender {
    XZPLCommand *command = [[XZPLCommand alloc] init];
    [command start];
    [command downloadGraphic:DeviceTypeR name:@"SAMPLE1" image:[UIImage imageNamed:@"image"]];
    [command end];
    [self printWithData:[command getCommand]];
}

- (IBAction)printGraphicAction:(id)sender {
    XZPLCommand *command = [[XZPLCommand alloc] init];
    [command start];
    [command printGraphicAtX:0 y:200 source:DeviceTypeR name:@"SAMPLE1" mx:2 my:2];
    [command end];
    [self printWithData:[command getCommand]];
}

- (IBAction)deleteGraphicAction:(id)sender {
    XZPLCommand *command = [[XZPLCommand alloc] init];
    [command start];
    [command deleteDownloadGraphic:DeviceTypeR name:@"SAMPLE1"];
    [command end];
    [self printWithData:[command getCommand]];
}

- (IBAction)setSpeedAction:(id)sender {
    XZPLCommand *command = [[XZPLCommand alloc] init];
    [command start];
    [command setPrintSpeed:(int)self.speedSlider.value];
    [command end];
    [self printWithData:[command getCommand]];
}

- (IBAction)setDensityAction:(id)sender {
    XZPLCommand *command = [[XZPLCommand alloc] init];
    [command start];
    [command setPrintDensity:(int)self.densitySlider.value];
    [command end];
    [self printWithData:[command getCommand]];
}

- (IBAction)testDirectionAction:(id)sender {
    XZPLCommand *command = [[XZPLCommand alloc] init];
    [command start];
    [command addTextAtX:20 y:100 content:@"image"];
    [command printImageAtX:0 y:200 image:[UIImage imageNamed:@"image"]];
    [command direction:self.directionSwitch.on];
    [command end];
    [self printWithData:[command getCommand]];
}

- (IBAction)printNumAction:(id)sender {
    XZPLCommand *command = [[XZPLCommand alloc] init];
    [command start];
    [command addTextAtX:20 y:100 content:@"image"];
    [command printImageAtX:0 y:200 image:[UIImage imageNamed:@"image"]];
    [command addPrintCount:(int)self.numSegment.selectedSegmentIndex + 1];
    [command end];
    [self printWithData:[command getCommand]];
}

- (IBAction)speedValueChanged:(UISlider *)sender {
    self.speedLabel.text = [NSString stringWithFormat:@"Speed:%d",(int)sender.value];
}

- (IBAction)densityValueChanged:(UISlider *)sender {
    self.densityLabel.text = [NSString stringWithFormat:@"Density:%d",(int)sender.value];
}

- (void)printWithData:(NSData *)dataM {
    
    if (_connectType == ConnectTypeBluetooth) {
        [_bleManager writeCommandWithData:dataM writeCallBack:^(CBCharacteristic *characteristic, NSError *error) {
            if (error) {
                NSLog(@"error:%@", error);
            } else {
                NSLog(@"write success");
            }
        }];
    } else if (_connectType == ConnectTypeWiFi) {
        [_wifiManager writeCommandWithData:dataM];
    } else {
        [self.view makeToast:@"printer no connect" duration:1.f position:CSToastPositionCenter];
    }
    
}

@end
